package edu.uky.ai.csp;

import java.util.HashMap;
import java.util.Scanner;

import edu.uky.ai.csp.kr.Domain;
import edu.uky.ai.csp.kr.NotEqualsConstraint;
import edu.uky.ai.csp.kr.Problem;
import edu.uky.ai.csp.kr.Variable;

/**
 * Models the problem of coloring a map so that no two adjacent regions have
 * the same color.  This problem assumes that graph is planar and thus can be
 * colored with at most 4 colors.
 * 
 * @author Stephen G. Ware
 */
public class MapColoring extends Problem {

	/**
	 * Constructs a new map coloring problem based on the adjacency list.
	 * 
	 * @param map a string adjacency list
	 */
	public MapColoring(String map) {
		HashMap<String, Variable> variables = new HashMap<>();
		Scanner scanner = new Scanner(map);
		while(scanner.hasNextLine()) {
			String line = scanner.nextLine().trim();
			String[] nodes = line.split(",");
			Variable variable = new Variable(nodes[0]);
			variables.put(nodes[0], variable);
			addVariable(variable, new Domain(variable, new String[]{"red", "blue", "green", "yellow"}));
		}
		scanner.close();
		scanner = new Scanner(map);
		while(scanner.hasNextLine()) {
			String line = scanner.nextLine().trim();
			String[] nodes = line.split(",");
			Variable left = variables.get(nodes[0]);
			for(int i=1; i<nodes.length; i++)
				addConstraint(new NotEqualsConstraint(left, variables.get(nodes[i])));
		}
		scanner.close();
	}
}
